 ; Ŀ
 ;   Sufi - move text, attdefs, and attribute block subentities            
 ;   coloured red and on layer 0 to layer text, colour bylayer.            
 ;   Copyright 2005 by Rocket Software Ltd.                                
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Terra - relayer & colour subentities in the block tables.  
 ; 
 (DEFUN TERRA (/ reww blok enam entt typ asoc8 asoc62)
  (setq reww t)
  (while (setq blok (tblnext "block" reww))           ; head entity from table
         (setq reww ())
         (setq enam (cdr (assoc -2 blok)))            ; first ename after head
         (while (and enam (setq entt (entget enam)))
                (setq typ (cdr (assoc 0 entt)))
                (if (and (member typ '("TEXT" "ATTDEF"))
                         (= (cdr (setq asoc8 (assoc 8 entt))) "0")
                         (= (cdr (setq asoc62 (assoc 62 entt))) 1))
                    (progn
                         (setq entt (subst (cons 8 "text") asoc8 entt))
                         (entmod (subst (cons 62 256) asoc62 entt))))
                (setq enam (entnext enam))))
 (princ))
 ; Ŀ
 ;   Terra end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Cotta - relayer attributes in block insertions.            
 ; 
 (DEFUN COTTA (/ ss len num enam entt as8 as62)
  (if (setq ss (ssget "X" (list (cons 0 "INSERT") (cons 66 1))))
      (progn
           (setq len (strcat "/" (itoa (sslength ss))))
           (setq num 0)           
           (while (setq enam (ssname ss num))
                  (grtext -2 (strcat (itoa (setq num (1+ num))) len))
                  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget (setq
                                                     enam (entnext enam)))))))
                         (if (and (= (cdr (setq as8 (assoc 8 entt))) "0")
                                  (= (cdr (setq as62 (assoc 62 entt))) 1))
                             (progn
                                  (setq entt (subst (cons 8 "text") as8 entt))
                                  (entmod (subst (cons 62 256)
                                                  as62 entt))))))))
 (princ))
 ; Ŀ
 ;   Cotta end.                                                            
 ; 

 ; Ŀ
 ;   Lapo - Fix the properties of a named layer, make it if it doesn't     
 ;   exist.                                                                
 ;   Arguments: Lanam, a layer name.                                       
 ;              Lacol, a layer color.                                      
 ;              Lint, a linetype.                                          
 ;   Calls nothing, Returns nothing.                                       
 ; 
 (DEFUN LAPO (lanam lacol lint)
  (if (tblsearch "layer" lanam)
      (command "-layer" "c" lacol lanam "lt" lint lanam "")
      (command "-layer" "m" lanam "c" lacol lanam "lt" lint lanam ""))
 (princ))
 ; Ŀ
 ;   Lapo end.                                                             
 ; 

 ; Ŀ
 ;   Sufi.                                                                 
 ; 
 (DEFUN C:SUFI (/ *error* ss)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk /)
  (if shk (write-line shk))
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   If the text layer doesn't exist then make it, else update it.         
 ; 
  (lapo "Text" "red" "continuous")
 ; Ŀ
 ;   Fix loose text and attdefs.                                           
 ; 
  (if (setq ss (ssget "x" '((-4 . "<and")
                            (-4 . "<or") (0 . "text")
                                         (0 . "attdef") (-4 . "or>")
                            (62 . 1) (8 . "0") (-4 . "and>"))))
      (command ".change" ss "" "p" "la" "text" "co" "bylayer" ""))
 ; Ŀ
 ;   Fix in the block tables any red text or attribute entity on layer 0.  
 ; 
  (terra)
 ; Ŀ
 ;   Relayer attributes in block insertions - these are not automatically  
 ;   updated when the block tables are changed.                            
 ; 
  (cotta)
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (command "undo" "end")
 (princ))